/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PlanDefinitionType {
    ORDERSET,
    CLINICALPROTOCOL,
    ECARULE,
    WORKFLOWDEFINITION,
    NULL;


    public static PlanDefinitionType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("order-set".equals(codeString)) {
            return ORDERSET;
        }
        if ("clinical-protocol".equals(codeString)) {
            return CLINICALPROTOCOL;
        }
        if ("eca-rule".equals(codeString)) {
            return ECARULE;
        }
        if ("workflow-definition".equals(codeString)) {
            return WORKFLOWDEFINITION;
        }
        throw new FHIRException("Unknown PlanDefinitionType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORDERSET: {
                return "order-set";
            }
            case CLINICALPROTOCOL: {
                return "clinical-protocol";
            }
            case ECARULE: {
                return "eca-rule";
            }
            case WORKFLOWDEFINITION: {
                return "workflow-definition";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/plan-definition-type";
    }

    public String getDefinition() {
        switch (this) {
            case ORDERSET: {
                return "A pre-defined and approved group of orders related to a particular clinical condition (e.g. hypertension treatment and monitoring) or stage of care (e.g. hospital admission to Coronary Care Unit). An order set is used as a checklist for the clinician when managing a patient with a specific condition. It is a structured collection of orders relevant to that condition and presented to the clinician in a computerized provider order entry (CPOE) system.";
            }
            case CLINICALPROTOCOL: {
                return "Defines a desired/typical sequence of clinical activities including preconditions, triggers and temporal relationships.";
            }
            case ECARULE: {
                return "A decision support rule of the form [on Event] if Condition then Action. It is intended to be a shareable, computable definition of actions that should be taken whenever some condition is met in response to a particular event or events.";
            }
            case WORKFLOWDEFINITION: {
                return "Defines the steps for a group of one or more systems in an event flow process along with the step constraints, sequence, pre-conditions and decision points to complete a particular objective.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORDERSET: {
                return "Order Set";
            }
            case CLINICALPROTOCOL: {
                return "Clinical Protocol";
            }
            case ECARULE: {
                return "ECA Rule";
            }
            case WORKFLOWDEFINITION: {
                return "Workflow Definition";
            }
        }
        return "?";
    }
}

