/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.GuidanceResponseStatus;

public class GuidanceResponseStatusEnumFactory
implements EnumFactory<GuidanceResponseStatus> {
    @Override
    public GuidanceResponseStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("success".equals(codeString)) {
            return GuidanceResponseStatus.SUCCESS;
        }
        if ("data-requested".equals(codeString)) {
            return GuidanceResponseStatus.DATAREQUESTED;
        }
        if ("data-required".equals(codeString)) {
            return GuidanceResponseStatus.DATAREQUIRED;
        }
        if ("in-progress".equals(codeString)) {
            return GuidanceResponseStatus.INPROGRESS;
        }
        if ("failure".equals(codeString)) {
            return GuidanceResponseStatus.FAILURE;
        }
        if ("entered-in-error".equals(codeString)) {
            return GuidanceResponseStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown GuidanceResponseStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(GuidanceResponseStatus code) {
        if (code == GuidanceResponseStatus.SUCCESS) {
            return "success";
        }
        if (code == GuidanceResponseStatus.DATAREQUESTED) {
            return "data-requested";
        }
        if (code == GuidanceResponseStatus.DATAREQUIRED) {
            return "data-required";
        }
        if (code == GuidanceResponseStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == GuidanceResponseStatus.FAILURE) {
            return "failure";
        }
        if (code == GuidanceResponseStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(GuidanceResponseStatus code) {
        return code.getSystem();
    }
}

