/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum BenefitType {
    BENEFIT,
    DEDUCTIBLE,
    VISIT,
    ROOM,
    COPAY,
    COPAYPERCENT,
    COPAYMAXIMUM,
    VISIONEXAM,
    VISIONGLASSES,
    VISIONCONTACTS,
    MEDICALPRIMARYCARE,
    PHARMACYDISPENSE,
    NULL;


    public static BenefitType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("benefit".equals(codeString)) {
            return BENEFIT;
        }
        if ("deductible".equals(codeString)) {
            return DEDUCTIBLE;
        }
        if ("visit".equals(codeString)) {
            return VISIT;
        }
        if ("room".equals(codeString)) {
            return ROOM;
        }
        if ("copay".equals(codeString)) {
            return COPAY;
        }
        if ("copay-percent".equals(codeString)) {
            return COPAYPERCENT;
        }
        if ("copay-maximum".equals(codeString)) {
            return COPAYMAXIMUM;
        }
        if ("vision-exam".equals(codeString)) {
            return VISIONEXAM;
        }
        if ("vision-glasses".equals(codeString)) {
            return VISIONGLASSES;
        }
        if ("vision-contacts".equals(codeString)) {
            return VISIONCONTACTS;
        }
        if ("medical-primarycare".equals(codeString)) {
            return MEDICALPRIMARYCARE;
        }
        if ("pharmacy-dispense".equals(codeString)) {
            return PHARMACYDISPENSE;
        }
        throw new FHIRException("Unknown BenefitType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BENEFIT: {
                return "benefit";
            }
            case DEDUCTIBLE: {
                return "deductible";
            }
            case VISIT: {
                return "visit";
            }
            case ROOM: {
                return "room";
            }
            case COPAY: {
                return "copay";
            }
            case COPAYPERCENT: {
                return "copay-percent";
            }
            case COPAYMAXIMUM: {
                return "copay-maximum";
            }
            case VISIONEXAM: {
                return "vision-exam";
            }
            case VISIONGLASSES: {
                return "vision-glasses";
            }
            case VISIONCONTACTS: {
                return "vision-contacts";
            }
            case MEDICALPRIMARYCARE: {
                return "medical-primarycare";
            }
            case PHARMACYDISPENSE: {
                return "pharmacy-dispense";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/benefit-type";
    }

    public String getDefinition() {
        switch (this) {
            case BENEFIT: {
                return "Maximum benefit allowable.";
            }
            case DEDUCTIBLE: {
                return "Cost to be incurred before benefits are applied";
            }
            case VISIT: {
                return "Service visit";
            }
            case ROOM: {
                return "Type of room";
            }
            case COPAY: {
                return "Copayment per service";
            }
            case COPAYPERCENT: {
                return "Copayment percentage per service";
            }
            case COPAYMAXIMUM: {
                return "Copayment maximum per service";
            }
            case VISIONEXAM: {
                return "Vision Exam";
            }
            case VISIONGLASSES: {
                return "Frames and lenses";
            }
            case VISIONCONTACTS: {
                return "Contact Lenses";
            }
            case MEDICALPRIMARYCARE: {
                return "Medical Primary Health Coverage";
            }
            case PHARMACYDISPENSE: {
                return "Pharmacy Dispense Coverage";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BENEFIT: {
                return "Benefit";
            }
            case DEDUCTIBLE: {
                return "Deductible";
            }
            case VISIT: {
                return "Visit";
            }
            case ROOM: {
                return "Room";
            }
            case COPAY: {
                return "Copayment per service";
            }
            case COPAYPERCENT: {
                return "Copayment Percent per service";
            }
            case COPAYMAXIMUM: {
                return "Copayment maximum per service";
            }
            case VISIONEXAM: {
                return "Vision Exam";
            }
            case VISIONGLASSES: {
                return "Vision Glasses";
            }
            case VISIONCONTACTS: {
                return "Vision Contacts Coverage";
            }
            case MEDICALPRIMARYCARE: {
                return "Medical Primary Health Coverage";
            }
            case PHARMACYDISPENSE: {
                return "Pharmacy Dispense Coverage";
            }
        }
        return "?";
    }
}

