/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventOutcome {
    RESOLVED,
    RECOVERING,
    ONGOING,
    RESOLVEDWITHSEQUELAE,
    FATAL,
    UNKNOWN,
    NULL;


    public static AdverseEventOutcome fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        if ("recovering".equals(codeString)) {
            return RECOVERING;
        }
        if ("ongoing".equals(codeString)) {
            return ONGOING;
        }
        if ("resolvedWithSequelae".equals(codeString)) {
            return RESOLVEDWITHSEQUELAE;
        }
        if ("fatal".equals(codeString)) {
            return FATAL;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown AdverseEventOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RESOLVED: {
                return "resolved";
            }
            case RECOVERING: {
                return "recovering";
            }
            case ONGOING: {
                return "ongoing";
            }
            case RESOLVEDWITHSEQUELAE: {
                return "resolvedWithSequelae";
            }
            case FATAL: {
                return "fatal";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/adverse-event-outcome";
    }

    public String getDefinition() {
        switch (this) {
            case RESOLVED: {
                return "";
            }
            case RECOVERING: {
                return "";
            }
            case ONGOING: {
                return "";
            }
            case RESOLVEDWITHSEQUELAE: {
                return "";
            }
            case FATAL: {
                return "";
            }
            case UNKNOWN: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RESOLVED: {
                return "Resolved";
            }
            case RECOVERING: {
                return "Recovering";
            }
            case ONGOING: {
                return "Ongoing";
            }
            case RESOLVEDWITHSEQUELAE: {
                return "Resolved with Sequelae";
            }
            case FATAL: {
                return "Fatal";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

