/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionConditionKind {
    APPLICABILITY,
    START,
    STOP,
    NULL;


    public static ActionConditionKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("applicability".equals(codeString)) {
            return APPLICABILITY;
        }
        if ("start".equals(codeString)) {
            return START;
        }
        if ("stop".equals(codeString)) {
            return STOP;
        }
        throw new FHIRException("Unknown ActionConditionKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case APPLICABILITY: {
                return "applicability";
            }
            case START: {
                return "start";
            }
            case STOP: {
                return "stop";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-condition-kind";
    }

    public String getDefinition() {
        switch (this) {
            case APPLICABILITY: {
                return "The condition describes whether or not a given action is applicable.";
            }
            case START: {
                return "The condition is a starting condition for the action.";
            }
            case STOP: {
                return "The condition is a stop, or exit condition for the action.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case APPLICABILITY: {
                return "Applicability";
            }
            case START: {
                return "Start";
            }
            case STOP: {
                return "Stop";
            }
        }
        return "?";
    }
}

