/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcedureStatus {
    PREPARATION,
    INPROGRESS,
    SUSPENDED,
    ABORTED,
    COMPLETED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static ProcedureStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preparation".equals(codeString)) {
            return PREPARATION;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("aborted".equals(codeString)) {
            return ABORTED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ProcedureStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PREPARATION: {
                return "preparation";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case ABORTED: {
                return "aborted";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/procedure-status";
    }

    public String getDefinition() {
        switch (this) {
            case PREPARATION: {
                return "The core procedure has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
            }
            case INPROGRESS: {
                return "The procedure is currently occurring.";
            }
            case SUSPENDED: {
                return "The procedure has been temporarily stopped but is expected to resume in the future";
            }
            case ABORTED: {
                return "The procedure was terminated without completing successfully.";
            }
            case COMPLETED: {
                return "All actions involved in the procedure have taken place.";
            }
            case ENTEREDINERROR: {
                return "This electronic record should never have existed.";
            }
            case UNKNOWN: {
                return "The authoring system does not know which of the status values currently applies for this procedure.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PREPARATION: {
                return "Preparation";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case ABORTED: {
                return "Aboted";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

