/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LibraryType {
    LOGICLIBRARY,
    MODELDEFINITION,
    ASSETCOLLECTION,
    MODULEDEFINITION,
    NULL;


    public static LibraryType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("logic-library".equals(codeString)) {
            return LOGICLIBRARY;
        }
        if ("model-definition".equals(codeString)) {
            return MODELDEFINITION;
        }
        if ("asset-collection".equals(codeString)) {
            return ASSETCOLLECTION;
        }
        if ("module-definition".equals(codeString)) {
            return MODULEDEFINITION;
        }
        throw new FHIRException("Unknown LibraryType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LOGICLIBRARY: {
                return "logic-library";
            }
            case MODELDEFINITION: {
                return "model-definition";
            }
            case ASSETCOLLECTION: {
                return "asset-collection";
            }
            case MODULEDEFINITION: {
                return "module-definition";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/library-type";
    }

    public String getDefinition() {
        switch (this) {
            case LOGICLIBRARY: {
                return "The resource is a shareable library of formalized knowledge";
            }
            case MODELDEFINITION: {
                return "The resource is a definition of an information model";
            }
            case ASSETCOLLECTION: {
                return "The resource is a collection of knowledge assets";
            }
            case MODULEDEFINITION: {
                return "The resource defines the dependencies, parameters, and data requirements for a particular module or evaluation context";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LOGICLIBRARY: {
                return "Logic Library";
            }
            case MODELDEFINITION: {
                return "Model Definition";
            }
            case ASSETCOLLECTION: {
                return "Asset Collection";
            }
            case MODULEDEFINITION: {
                return "Module Definition";
            }
        }
        return "?";
    }
}

