/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Forms {
    _1,
    _2,
    NULL;


    public static Forms fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        throw new FHIRException("Unknown Forms code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/forms-codes";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "Example: The #1 form to be used when printing this information.";
            }
            case _2: {
                return "Example: The #2 form to be used when printing this information.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "Form #1";
            }
            case _2: {
                return "Form #1";
            }
        }
        return "?";
    }
}

