/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExRevenueCenter {
    _0370,
    _0420,
    _0421,
    _0440,
    _0441,
    _0450,
    _0451,
    _0452,
    _0010,
    NULL;


    public static ExRevenueCenter fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("0370".equals(codeString)) {
            return _0370;
        }
        if ("0420".equals(codeString)) {
            return _0420;
        }
        if ("0421".equals(codeString)) {
            return _0421;
        }
        if ("0440".equals(codeString)) {
            return _0440;
        }
        if ("0441".equals(codeString)) {
            return _0441;
        }
        if ("0450".equals(codeString)) {
            return _0450;
        }
        if ("0451".equals(codeString)) {
            return _0451;
        }
        if ("0452".equals(codeString)) {
            return _0452;
        }
        if ("0010".equals(codeString)) {
            return _0010;
        }
        throw new FHIRException("Unknown ExRevenueCenter code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _0370: {
                return "0370";
            }
            case _0420: {
                return "0420";
            }
            case _0421: {
                return "0421";
            }
            case _0440: {
                return "0440";
            }
            case _0441: {
                return "0441";
            }
            case _0450: {
                return "0450";
            }
            case _0451: {
                return "0451";
            }
            case _0452: {
                return "0452";
            }
            case _0010: {
                return "0010";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-revenue-center";
    }

    public String getDefinition() {
        switch (this) {
            case _0370: {
                return "Anaesthesia.";
            }
            case _0420: {
                return "Physical Therapy.";
            }
            case _0421: {
                return "Physical Therapy - visit charge.";
            }
            case _0440: {
                return "Speech-Language Pathology.";
            }
            case _0441: {
                return "Speech-Language Pathology- visit charge";
            }
            case _0450: {
                return "Emergency Room";
            }
            case _0451: {
                return "Emergency Room - EM/EMTALA";
            }
            case _0452: {
                return "Emergency Room - beyond EMTALA";
            }
            case _0010: {
                return "Vision Clinic";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _0370: {
                return "Anaesthesia";
            }
            case _0420: {
                return "Physical Therapy";
            }
            case _0421: {
                return "Physical Therapy - ";
            }
            case _0440: {
                return "Speech-Language Pathology";
            }
            case _0441: {
                return "Speech-Language Pathology - Visit";
            }
            case _0450: {
                return "Emergency Room";
            }
            case _0451: {
                return "Emergency Room - EM/EMTALA";
            }
            case _0452: {
                return "Emergency Room - beyond EMTALA";
            }
            case _0010: {
                return "Vision Clinic";
            }
        }
        return "?";
    }
}

