/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CqifEvidenceQuality {
    HIGH,
    MODERATE,
    LOW,
    VERYLOW,
    NULL;


    public static CqifEvidenceQuality fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("high".equals(codeString)) {
            return HIGH;
        }
        if ("moderate".equals(codeString)) {
            return MODERATE;
        }
        if ("low".equals(codeString)) {
            return LOW;
        }
        if ("very-low".equals(codeString)) {
            return VERYLOW;
        }
        throw new FHIRException("Unknown CqifEvidenceQuality code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HIGH: {
                return "high";
            }
            case MODERATE: {
                return "moderate";
            }
            case LOW: {
                return "low";
            }
            case VERYLOW: {
                return "very-low";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/evidence-quality";
    }

    public String getDefinition() {
        switch (this) {
            case HIGH: {
                return "High quality evidence";
            }
            case MODERATE: {
                return "Moderate quality evidence";
            }
            case LOW: {
                return "Low quality evidence";
            }
            case VERYLOW: {
                return "Very low quality evidence";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HIGH: {
                return "High quality";
            }
            case MODERATE: {
                return "Moderate quality";
            }
            case LOW: {
                return "Low quality";
            }
            case VERYLOW: {
                return "Very low quality";
            }
        }
        return "?";
    }
}

