/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.CommunicationRequestStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="CommunicationRequest", profile="http://hl7.org/fhir/profiles/CommunicationRequest", id="communicationrequest")
public class CommunicationRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="CommunicationRequest.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="category", path="CommunicationRequest.category", description="", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="sender", path="CommunicationRequest.sender", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner"), @Compartment(name="Device")})
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    @SearchParamDefinition(name="recipient", path="CommunicationRequest.recipient", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner"), @Compartment(name="Device")})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    @SearchParamDefinition(name="medium", path="CommunicationRequest.medium", description="", type="token")
    public static final String SP_MEDIUM = "medium";
    public static final TokenClientParam MEDIUM = new TokenClientParam("medium");
    @SearchParamDefinition(name="requester", path="CommunicationRequest.requester", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner")})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    @SearchParamDefinition(name="status", path="CommunicationRequest.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="encounter", path="CommunicationRequest.encounter", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="time", path="CommunicationRequest.scheduledDateTime", description="", type="date")
    public static final String SP_TIME = "time";
    public static final DateClientParam TIME = new DateClientParam("time");
    @SearchParamDefinition(name="requested", path="CommunicationRequest.requestedOn", description="", type="date")
    public static final String SP_REQUESTED = "requested";
    public static final DateClientParam REQUESTED = new DateClientParam("requested");
    @SearchParamDefinition(name="subject", path="CommunicationRequest.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="priority", path="CommunicationRequest.priority", description="", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="patient", path="CommunicationRequest.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_ENCOUNTER = new Include("CommunicationRequest:encounter");
    public static final Include INCLUDE_PATIENT = new Include("CommunicationRequest:patient");
    public static final Include INCLUDE_RECIPIENT = new Include("CommunicationRequest:recipient");
    public static final Include INCLUDE_REQUESTER = new Include("CommunicationRequest:requester");
    public static final Include INCLUDE_SENDER = new Include("CommunicationRequest:sender");
    public static final Include INCLUDE_SUBJECT = new Include("CommunicationRequest:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A unique ID of this request for reference purposes. It must be provided if user wants it returned as part of any output, otherwise it will be autogenerated, if needed, by CDS system. Does not need to be the actual ID of the source system.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="category", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of message to be sent such as alert, notification, reminder, instruction, etc.")
    private CodeableConceptDt myCategory;
    @Child(name="sender", order=2, min=0, max=1, summary=false, modifier=false, type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication")
    private ResourceReferenceDt mySender;
    @Child(name="recipient", order=3, min=0, max=-1, summary=false, modifier=false, type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which is the intended target of the communication")
    private List<ResourceReferenceDt> myRecipient;
    @Child(name="payload", order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Text, attachment(s), or resource(s) to be communicated to the recipient")
    private List<Payload> myPayload;
    @Child(name="medium", type={CodeableConceptDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A channel that was used for this communication (e.g. email, fax).")
    private List<CodeableConceptDt> myMedium;
    @Child(name="requester", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="", formalDefinition="The responsible person who authorizes this order, e.g. physician. This may be different than the author of the order statement, e.g. clerk, who may have entered the statement into the order entry application.")
    private ResourceReferenceDt myRequester;
    @Child(name="status", type={CodeDt.class}, order=7, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="The status of the proposal or order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/communication-request-status")
    private BoundCodeDt<CommunicationRequestStatusEnum> myStatus;
    @Child(name="encounter", order=8, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="", formalDefinition="The encounter within which the communication request was created.")
    private ResourceReferenceDt myEncounter;
    @Child(name="scheduled", order=9, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="", formalDefinition="The time when this communication is to occur.")
    private IDatatype myScheduled;
    @Child(name="reason", type={CodeableConceptDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The reason or justification for the communication request.")
    private List<CodeableConceptDt> myReason;
    @Child(name="requestedOn", type={DateTimeDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time when the request was made.")
    private DateTimeDt myRequestedOn;
    @Child(name="subject", order=12, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The patient who is the focus of this communication request.")
    private ResourceReferenceDt mySubject;
    @Child(name="priority", type={CodeableConceptDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.")
    private CodeableConceptDt myPriority;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCategory, this.mySender, this.myRecipient, this.myPayload, this.myMedium, this.myRequester, this.myStatus, this.myEncounter, this.myScheduled, this.myReason, this.myRequestedOn, this.mySubject, this.myPriority});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCategory, this.mySender, this.myRecipient, this.myPayload, this.myMedium, this.myRequester, this.myStatus, this.myEncounter, this.myScheduled, this.myReason, this.myRequestedOn, this.mySubject, this.myPriority});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public CommunicationRequest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public CommunicationRequest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public CommunicationRequest setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public ResourceReferenceDt getSender() {
        if (this.mySender == null) {
            this.mySender = new ResourceReferenceDt();
        }
        return this.mySender;
    }

    public CommunicationRequest setSender(ResourceReferenceDt theValue) {
        this.mySender = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getRecipient() {
        if (this.myRecipient == null) {
            this.myRecipient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRecipient;
    }

    public CommunicationRequest setRecipient(List<ResourceReferenceDt> theValue) {
        this.myRecipient = theValue;
        return this;
    }

    public ResourceReferenceDt addRecipient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRecipient().add(newType);
        return newType;
    }

    public List<Payload> getPayload() {
        if (this.myPayload == null) {
            this.myPayload = new ArrayList<Payload>();
        }
        return this.myPayload;
    }

    public CommunicationRequest setPayload(List<Payload> theValue) {
        this.myPayload = theValue;
        return this;
    }

    public Payload addPayload() {
        Payload newType = new Payload();
        this.getPayload().add(newType);
        return newType;
    }

    public CommunicationRequest addPayload(Payload theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPayload().add(theValue);
        return this;
    }

    public Payload getPayloadFirstRep() {
        if (this.getPayload().isEmpty()) {
            return this.addPayload();
        }
        return this.getPayload().get(0);
    }

    public List<CodeableConceptDt> getMedium() {
        if (this.myMedium == null) {
            this.myMedium = new ArrayList<CodeableConceptDt>();
        }
        return this.myMedium;
    }

    public CommunicationRequest setMedium(List<CodeableConceptDt> theValue) {
        this.myMedium = theValue;
        return this;
    }

    public CodeableConceptDt addMedium() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getMedium().add(newType);
        return newType;
    }

    public CommunicationRequest addMedium(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMedium().add(theValue);
        return this;
    }

    public CodeableConceptDt getMediumFirstRep() {
        if (this.getMedium().isEmpty()) {
            return this.addMedium();
        }
        return this.getMedium().get(0);
    }

    public ResourceReferenceDt getRequester() {
        if (this.myRequester == null) {
            this.myRequester = new ResourceReferenceDt();
        }
        return this.myRequester;
    }

    public CommunicationRequest setRequester(ResourceReferenceDt theValue) {
        this.myRequester = theValue;
        return this;
    }

    public BoundCodeDt<CommunicationRequestStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CommunicationRequestStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public CommunicationRequest setStatus(BoundCodeDt<CommunicationRequestStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public CommunicationRequest setStatus(CommunicationRequestStatusEnum theValue) {
        this.setStatus((BoundCodeDt<CommunicationRequestStatusEnum>)new BoundCodeDt(CommunicationRequestStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public CommunicationRequest setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public IDatatype getScheduled() {
        return this.myScheduled;
    }

    public CommunicationRequest setScheduled(IDatatype theValue) {
        this.myScheduled = theValue;
        return this;
    }

    public List<CodeableConceptDt> getReason() {
        if (this.myReason == null) {
            this.myReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myReason;
    }

    public CommunicationRequest setReason(List<CodeableConceptDt> theValue) {
        this.myReason = theValue;
        return this;
    }

    public CodeableConceptDt addReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReason().add(newType);
        return newType;
    }

    public CommunicationRequest addReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            return this.addReason();
        }
        return this.getReason().get(0);
    }

    public DateTimeDt getRequestedOnElement() {
        if (this.myRequestedOn == null) {
            this.myRequestedOn = new DateTimeDt();
        }
        return this.myRequestedOn;
    }

    public Date getRequestedOn() {
        return (Date)this.getRequestedOnElement().getValue();
    }

    public CommunicationRequest setRequestedOn(DateTimeDt theValue) {
        this.myRequestedOn = theValue;
        return this;
    }

    public CommunicationRequest setRequestedOn(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRequestedOn = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public CommunicationRequest setRequestedOnWithSecondsPrecision(Date theDate) {
        this.myRequestedOn = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public CommunicationRequest setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public CodeableConceptDt getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new CodeableConceptDt();
        }
        return this.myPriority;
    }

    public CommunicationRequest setPriority(CodeableConceptDt theValue) {
        this.myPriority = theValue;
        return this;
    }

    public String getResourceName() {
        return "CommunicationRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Payload
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="content", order=0, min=1, max=1, summary=false, modifier=false, type={StringDt.class, AttachmentDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="The communicated content (or for multi-part communications, one portion of the communication)")
        private IDatatype myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContent});
        }

        public IDatatype getContent() {
            return this.myContent;
        }

        public Payload setContent(IDatatype theValue) {
            this.myContent = theValue;
            return this;
        }
    }
}

