/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IIdType;

public class HttpDeleteClientInvocation
extends BaseHttpClientInvocation {
    private String myUrlPath;
    private Map<String, List<String>> myParams;

    public HttpDeleteClientInvocation(FhirContext theContext, IIdType theId) {
        super(theContext);
        this.myUrlPath = theId.toUnqualifiedVersionless().getValue();
    }

    public HttpDeleteClientInvocation(FhirContext theContext, String theSearchUrl) {
        super(theContext);
        this.myUrlPath = theSearchUrl;
    }

    public HttpDeleteClientInvocation(FhirContext theContext, String theResourceType, Map<String, List<String>> theParams) {
        super(theContext);
        this.myUrlPath = theResourceType;
        this.myParams = theParams;
    }

    @Override
    public IHttpRequest asHttpRequest(String theUrlBase, Map<String, List<String>> theExtraParams, EncodingEnum theEncoding, Boolean thePrettyPrint) {
        StringBuilder b = new StringBuilder();
        b.append(theUrlBase);
        if (!theUrlBase.endsWith("/")) {
            b.append('/');
        }
        b.append(this.myUrlPath);
        HttpDeleteClientInvocation.appendExtraParamsWithQuestionMark(this.myParams, b, b.indexOf("?") == -1);
        HttpDeleteClientInvocation.appendExtraParamsWithQuestionMark(theExtraParams, b, b.indexOf("?") == -1);
        return this.createHttpRequest(b.toString(), theEncoding, RequestTypeEnum.DELETE);
    }

    @Override
    protected IHttpRequest createHttpRequest(String theUrl, EncodingEnum theEncoding, RequestTypeEnum theRequestType) {
        return super.createHttpRequest(theUrl, theEncoding, theRequestType);
    }
}

