/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeChildUndeclaredExtensionDefinition
extends BaseRuntimeChildDefinition {
    private static final String VALUE_REFERENCE = "valueReference";
    private static final String VALUE_RESOURCE = "valueResource";
    private Map<String, BaseRuntimeElementDefinition<?>> myAttributeNameToDefinition;
    private Map<Class<? extends IBase>, String> myDatatypeToAttributeName;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myDatatypeToDefinition;
    private static final Logger ourLog = LoggerFactory.getLogger(RuntimeChildUndeclaredExtensionDefinition.class);

    private void addReferenceBinding(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions, String value) {
        ArrayList<Class<IBaseResource>> types = new ArrayList<Class<IBaseResource>>();
        types.add(IBaseResource.class);
        BaseRuntimeElementDefinition<?> def = this.findResourceReferenceDefinition(theClassToElementDefinitions);
        this.myAttributeNameToDefinition.put(value, def);
        if (value != VALUE_RESOURCE) {
            this.myDatatypeToAttributeName.put(theContext.getVersion().getResourceReferenceType(), value);
            this.myDatatypeToDefinition.put(BaseResourceReferenceDt.class, def);
            this.myDatatypeToDefinition.put(theContext.getVersion().getResourceReferenceType(), def);
        }
    }

    @Override
    public BaseRuntimeChildDefinition.IAccessor getAccessor() {
        return new BaseRuntimeChildDefinition.IAccessor(){

            @Override
            public List<IBase> getValues(IBase theTarget) {
                ExtensionDt target = (ExtensionDt)theTarget;
                if (target.getValue() != null) {
                    return Collections.singletonList(target.getValue());
                }
                ArrayList<IBase> retVal = new ArrayList<IBase>(target.getUndeclaredExtensions());
                return retVal;
            }
        };
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        return this.myAttributeNameToDefinition.get(theName);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theType) {
        return this.myDatatypeToDefinition.get(theType);
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToAttributeName.get(theDatatype);
    }

    @Override
    public String getElementName() {
        return "extension";
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public BaseRuntimeChildDefinition.IMutator getMutator() {
        return new BaseRuntimeChildDefinition.IMutator(){

            @Override
            public void addValue(IBase theTarget, IBase theValue) {
                ExtensionDt target = (ExtensionDt)theTarget;
                if (theValue instanceof IDatatype) {
                    target.setValue((IDatatype)theTarget);
                } else {
                    target.getUndeclaredExtensions().add((ExtensionDt)theValue);
                }
            }

            @Override
            public void setValue(IBase theTarget, IBase theValue) {
                ExtensionDt target = (ExtensionDt)theTarget;
                if (theValue instanceof IDatatype) {
                    target.setValue((IDatatype)theTarget);
                } else {
                    target.getUndeclaredExtensions().clear();
                    target.getUndeclaredExtensions().add((ExtensionDt)theValue);
                }
            }
        };
    }

    @Override
    public Set<String> getValidChildNames() {
        return this.myAttributeNameToDefinition.keySet();
    }

    @Override
    public boolean isSummary() {
        return false;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        HashMap datatypeAttributeNameToDefinition = new HashMap();
        this.myDatatypeToAttributeName = new HashMap<Class<? extends IBase>, String>();
        this.myDatatypeToDefinition = new HashMap();
        for (BaseRuntimeElementDefinition<?> next : theClassToElementDefinitions.values()) {
            String qualifiedName;
            if (!(next instanceof IRuntimeDatatypeDefinition)) continue;
            this.myDatatypeToDefinition.put(next.getImplementingClass(), next);
            boolean isSpecialization = ((IRuntimeDatatypeDefinition)((Object)next)).isSpecialization();
            if (isSpecialization) {
                ourLog.trace("Not adding specialization: {}", next.getImplementingClass());
            }
            if (isSpecialization || !next.isStandardType() || !(qualifiedName = next.getImplementingClass().getName()).startsWith("ca.uhn.fhir.model") && !qualifiedName.startsWith("org.hl7.fhir")) continue;
            String attrName = RuntimeChildUndeclaredExtensionDefinition.createExtensionChildName(next);
            if (datatypeAttributeNameToDefinition.containsKey(attrName)) {
                BaseRuntimeElementDefinition existing = (BaseRuntimeElementDefinition)datatypeAttributeNameToDefinition.get(attrName);
                throw new ConfigurationException("More than one child of " + this.getElementName() + " matches attribute name " + attrName + ". Found [" + existing.getImplementingClass().getName() + "] and [" + next.getImplementingClass().getName() + "]");
            }
            datatypeAttributeNameToDefinition.put(attrName, next);
            datatypeAttributeNameToDefinition.put(attrName.toLowerCase(), next);
            this.myDatatypeToAttributeName.put(next.getImplementingClass(), attrName);
        }
        this.myAttributeNameToDefinition = datatypeAttributeNameToDefinition;
        this.addReferenceBinding(theContext, theClassToElementDefinitions, VALUE_RESOURCE);
        this.addReferenceBinding(theContext, theClassToElementDefinitions, VALUE_REFERENCE);
    }

    public static String createExtensionChildName(BaseRuntimeElementDefinition<?> next) {
        String attrName = "value" + WordUtils.capitalize((String)next.getName());
        return attrName;
    }
}

