/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.PathResolver;

@RequestScoped
public class DefaultPathResolver
implements PathResolver {
    private final FormatResolver resolver;

    public DefaultPathResolver(FormatResolver resolver) {
        this.resolver = resolver;
    }

    public String pathFor(ResourceMethod method) {
        String format = this.resolver.getAcceptFormat();
        String suffix = "";
        if (format != null && !format.equals("html")) {
            suffix = "." + format;
        }
        String name = method.getResource().getType().getSimpleName();
        String folderName = this.extractControllerFromName(name);
        return this.getPrefix() + folderName + "/" + method.getMethod().getName() + suffix + "." + this.getExtension();
    }

    protected String getPrefix() {
        return "/WEB-INF/jsp/";
    }

    protected String getExtension() {
        return "jsp";
    }

    protected String extractControllerFromName(String baseName) {
        if ((baseName = this.lowerFirstCharacter(baseName)).endsWith("Controller")) {
            return baseName.substring(0, baseName.lastIndexOf("Controller"));
        }
        return baseName;
    }

    private String lowerFirstCharacter(String baseName) {
        return baseName.toLowerCase().substring(0, 1) + baseName.substring(1, baseName.length());
    }
}

