/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.util.LRUCache;
import br.com.caelum.vraptor.view.AcceptHeaderToFormat;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultAcceptHeaderToFormat
implements AcceptHeaderToFormat {
    private static final Map<String, String> acceptToFormatCache = Collections.synchronizedMap(new LRUCache(100));
    private static final String DEFAULT_FORMAT = "html";
    private static final double DEFAULT_QUALIFIER_VALUE = 0.01;
    protected final Map<String, String> mimeToFormat = new ConcurrentHashMap<String, String>();

    public DefaultAcceptHeaderToFormat() {
        this.mimeToFormat.put("text/html", DEFAULT_FORMAT);
        this.mimeToFormat.put("application/json", "json");
        this.mimeToFormat.put("application/xml", "xml");
        this.mimeToFormat.put("text/xml", "xml");
        this.mimeToFormat.put("xml", "xml");
    }

    @Override
    public String getFormat(String acceptHeader) {
        if (acceptHeader == null || acceptHeader.trim().equals("")) {
            return DEFAULT_FORMAT;
        }
        if (acceptHeader.contains(DEFAULT_FORMAT)) {
            return DEFAULT_FORMAT;
        }
        if (acceptToFormatCache.containsKey(acceptHeader)) {
            return acceptToFormatCache.get(acceptHeader);
        }
        return this.chooseMimeType(acceptHeader);
    }

    private String chooseMimeType(String acceptHeader) {
        String[] mimeTypes;
        for (String mimeType : mimeTypes = this.getOrderedMimeTypes(acceptHeader)) {
            if (!this.mimeToFormat.containsKey(mimeType)) continue;
            String format = this.mimeToFormat.get(mimeType);
            acceptToFormatCache.put(acceptHeader, format);
            return format;
        }
        return mimeTypes[0];
    }

    String[] getOrderedMimeTypes(String acceptHeader) {
        String[] types = acceptHeader.split(",");
        if (types.length == 0) {
            return new String[]{types[0].split(";")[0]};
        }
        TreeSet mimes = Sets.newTreeSet();
        for (String string : types) {
            mimes.add(this.convertToMimeType(string));
        }
        return Collections2.transform((Collection)mimes, this.mimeType()).toArray(new String[mimes.size()]);
    }

    private Function<MimeType, String> mimeType() {
        return new Function<MimeType, String>(){

            public String apply(MimeType mime) {
                return mime.getType().trim();
            }
        };
    }

    private MimeType convertToMimeType(String string) {
        if (string.contains("*/*")) {
            return new MimeType("text/html", 0.01);
        }
        if (string.contains(";")) {
            String type = string.substring(0, string.indexOf(59));
            return new MimeType(type, this.extractQualifier(string));
        }
        return new MimeType(string, 1.0);
    }

    private double extractQualifier(String string) {
        double qualifier = 0.01;
        if (string.contains("q=")) {
            Matcher matcher = Pattern.compile("\\s*q=(.+)\\s*").matcher(string);
            matcher.find();
            String value = matcher.group(1);
            qualifier = Double.parseDouble(value);
        }
        return qualifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MimeType
    implements Comparable<MimeType> {
        String type;
        double qualifier;

        public MimeType(String type, double qualifier) {
            this.type = type;
            this.qualifier = qualifier;
        }

        @Override
        public int compareTo(MimeType mime) {
            return Double.compare(mime.qualifier, this.qualifier);
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

