/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.validator.I18nParam;
import br.com.caelum.vraptor.validator.Message;
import com.google.common.base.Objects;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class I18nMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private final Object category;
    private final String message;
    private final Object[] parameters;
    private transient ResourceBundle bundle;

    public I18nMessage(I18nParam category, String message, Object ... parameters) {
        this.category = category;
        this.message = message;
        this.parameters = parameters;
    }

    public I18nMessage(String category, String message, Object ... parameters) {
        this.category = category;
        this.message = message;
        this.parameters = parameters;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public boolean hasBundle() {
        return this.bundle != null;
    }

    public String getMessage() {
        this.checkBundle();
        return MessageFormat.format(this.bundle.getString(this.message), this.i18n(this.parameters));
    }

    private void checkBundle() {
        if (this.bundle == null) {
            throw new IllegalStateException("You must set the bundle before using the I18nMessage");
        }
    }

    private Object[] i18n(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof I18nParam)) continue;
            parameters[i] = ((I18nParam)parameters[i]).getKey(this.bundle);
        }
        return parameters;
    }

    public String getCategory() {
        if (this.category instanceof I18nParam) {
            this.checkBundle();
            return ((I18nParam)this.category).getKey(this.bundle);
        }
        return this.category.toString();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("category", this.category).add("message", (Object)this.message).add("parameters", (Object)this.parameters).toString();
    }
}

