/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.JSONPSerialization;
import br.com.caelum.vraptor.serialization.JSONSerialization;
import br.com.caelum.vraptor.serialization.ProxyInitializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamJSONSerialization;
import br.com.caelum.vraptor.serialization.xstream.XStreamSerializer;
import br.com.caelum.vraptor.view.ResultException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletResponse;

public class XStreamJSONPSerialization
implements JSONPSerialization {
    private final HttpServletResponse response;
    private final TypeNameExtractor extractor;
    private final ProxyInitializer initializer;
    private final XStreamBuilder builder;

    public XStreamJSONPSerialization(HttpServletResponse response, TypeNameExtractor extractor, ProxyInitializer initializer, XStreamBuilder builder) {
        this.response = response;
        this.extractor = extractor;
        this.initializer = initializer;
        this.builder = builder;
    }

    public JSONSerialization withCallback(final String callbackName) {
        return new XStreamJSONSerialization(this.response, this.extractor, this.initializer, this.builder){

            protected SerializerBuilder getSerializer() {
                try {
                    final PrintWriter writer = this.response.getWriter();
                    final StringWriter out = new StringWriter();
                    return new XStreamSerializer(super.getXStream(), new PrintWriter(out), this.extractor, this.initializer){

                        public void serialize() {
                            super.serialize();
                            writer.append(callbackName).append("(").append(out.getBuffer()).append(")");
                            writer.close();
                        }
                    };
                }
                catch (IOException e) {
                    throw new ResultException("Unable to serialize data", e);
                }
            }
        };
    }
}

