/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Component;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class XStreamConverters {
    private final List<Converter> converters;
    private final List<SingleValueConverter> singleValueConverters;
    private static final Logger logger = LoggerFactory.getLogger(XStreamConverters.class);

    public XStreamConverters(List<Converter> converters, List<SingleValueConverter> singleValueConverters) {
        this.converters = (List)Objects.firstNonNull(converters, (Object)Lists.newArrayList());
        this.singleValueConverters = (List)Objects.firstNonNull(singleValueConverters, (Object)Lists.newArrayList());
    }

    public void registerComponents(XStream xstream) {
        for (Converter converter : this.converters) {
            xstream.registerConverter(converter);
            logger.debug("registered Xstream converter for" + converter.getClass().getName());
        }
        for (SingleValueConverter singleValueConverter : this.singleValueConverters) {
            xstream.registerConverter(singleValueConverter);
            logger.debug("registered Xstream converter for" + singleValueConverter.getClass().getName());
        }
    }

    @Component
    @ApplicationScoped
    public static class NullConverter
    implements SingleValueConverter {
        public String toString(Object o) {
            return null;
        }

        public Object fromString(String s) {
            return null;
        }

        public boolean canConvert(Class aClass) {
            return false;
        }
    }
}

