/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.interceptor.DefaultTypeNameExtractor;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.serialization.xstream.VRaptorClassMapper;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamConverters;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;

@PrototypeScoped
@Component
public class XStreamBuilderImpl
implements XStreamBuilder {
    private final XStreamConverters converters;
    private final TypeNameExtractor extractor;
    private boolean indented;
    private boolean withoutRoot;
    protected static final String DEFAULT_NEW_LINE = "";
    protected static final char[] DEFAULT_LINE_INDENTER = new char[0];
    protected static final String INDENTED_NEW_LINE = "\n";
    protected static final char[] INDENTED_LINE_INDENTER = new char[]{' ', ' '};

    public XStreamBuilderImpl(XStreamConverters converters, TypeNameExtractor extractor) {
        this.converters = converters;
        this.extractor = extractor;
    }

    public static XStreamBuilder cleanInstance(Converter ... converters) {
        return new XStreamBuilderImpl(new XStreamConverters(Arrays.asList(converters), Collections.<SingleValueConverter>emptyList()), new DefaultTypeNameExtractor());
    }

    public XStream xmlInstance() {
        XStream xstream = new XStream(){
            {
                this.setMode(1001);
            }

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new VRaptorClassMapper((Mapper)next, XStreamBuilderImpl.this.extractor);
            }
        };
        this.converters.registerComponents(xstream);
        return xstream;
    }

    public XStream jsonInstance() {
        XStream xstream = new XStream(this.getHierarchicalStreamDriver()){
            {
                this.setMode(1001);
            }

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new VRaptorClassMapper((Mapper)next, XStreamBuilderImpl.this.extractor);
            }
        };
        this.converters.registerComponents(xstream);
        return xstream;
    }

    protected HierarchicalStreamDriver getHierarchicalStreamDriver() {
        final String newLine = this.indented ? INDENTED_NEW_LINE : DEFAULT_NEW_LINE;
        final char[] lineIndenter = this.indented ? INDENTED_LINE_INDENTER : DEFAULT_LINE_INDENTER;
        return new JsonHierarchicalStreamDriver(){

            public HierarchicalStreamWriter createWriter(Writer writer) {
                if (XStreamBuilderImpl.this.withoutRoot) {
                    return new JsonWriter(writer, lineIndenter, newLine, 1);
                }
                return new JsonWriter(writer, lineIndenter, newLine);
            }
        };
    }

    public XStreamBuilder indented() {
        this.indented = true;
        return this;
    }

    public XStreamBuilder withoutRoot() {
        this.withoutRoot = true;
        return this;
    }
}

