/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.scan;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.scan.DynamicWebAppBootstrap;
import br.com.caelum.vraptor.scan.ScannerException;
import br.com.caelum.vraptor.scan.ScannotationComponentScanner;
import br.com.caelum.vraptor.scan.WebAppBootstrap;
import br.com.caelum.vraptor.scan.WebBasedClasspathResolver;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppBootstrapFactory {
    private static final Logger logger = LoggerFactory.getLogger(WebAppBootstrapFactory.class);

    public WebAppBootstrap create(BasicConfiguration config) {
        try {
            Class<?> clazz = Class.forName("br.com.caelum.vraptor.generated.StaticProjectBootstrap");
            logger.info("Found a static WebAppBootstrap; using it and skipping cp scanning.");
            return (WebAppBootstrap)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.info("No static WebAppBootstrap found.");
            if (!config.isClasspathScanningEnabled()) {
                logger.info("Classpath scanning is disabled.");
                return new WebAppBootstrap(){

                    public void configure(ComponentRegistry registry) {
                    }
                };
            }
            WebBasedClasspathResolver resolver = new WebBasedClasspathResolver(config.getServletContext());
            logger.trace("Start classpath scanning");
            ScannotationComponentScanner scanner = new ScannotationComponentScanner();
            Collection<String> classNames = scanner.scan(resolver);
            logger.trace("End classpath scanning");
            DynamicWebAppBootstrap wab = new DynamicWebAppBootstrap(classNames);
            return wab;
        }
        catch (Exception e) {
            throw new ScannerException("Error while creating the StaticWebAppBootstrap", e);
        }
    }
}

