/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.scan;

import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.ioc.Stereotype;
import br.com.caelum.vraptor.scan.ClasspathResolver;
import br.com.caelum.vraptor.scan.ComponentScanner;
import br.com.caelum.vraptor.scan.ScannerException;
import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.vidageek.mirror.dsl.Mirror;
import org.scannotation.AnnotationDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannotationComponentScanner
implements ComponentScanner {
    private static final Logger logger = LoggerFactory.getLogger(ScannotationComponentScanner.class);

    @Override
    public Collection<String> scan(ClasspathResolver resolver) {
        URL webInfClasses = resolver.findWebInfClassesLocation();
        List<String> basePackages = resolver.findBasePackages();
        HashSet<String> results = new HashSet<String>();
        Map<String, Set<String>> webInfClassesAnnotationMap = this.scanWebInfClasses(webInfClasses);
        Map<String, Set<String>> basePackagesAnnotationMap = this.scanBasePackages(basePackages, resolver);
        Set<String> stereotypeNames = this.findStereotypes(webInfClassesAnnotationMap, basePackagesAnnotationMap, basePackages);
        this.findComponentsFromWebInfClasses(webInfClassesAnnotationMap, stereotypeNames, results);
        this.findComponentsFromBasePackages(basePackagesAnnotationMap, basePackages, results);
        return results;
    }

    private Map<String, Set<String>> scanWebInfClasses(URL webInfClasses) {
        try {
            AnnotationDB db = this.createAnnotationDB();
            db.scanArchives(new URL[]{webInfClasses});
            return db.getAnnotationIndex();
        }
        catch (IOException e) {
            throw new ScannerException("Could not scan WEB-INF/classes", e);
        }
    }

    private Map<String, Set<String>> scanBasePackages(List<String> basePackages, ClasspathResolver resolver) {
        try {
            AnnotationDB db = this.createAnnotationDB();
            for (String basePackage : basePackages) {
                this.scanPackage(basePackage, db, resolver);
            }
            return db.getAnnotationIndex();
        }
        catch (IOException e) {
            throw new ScannerException("Could not scan base packages", e);
        }
    }

    private void scanPackage(String basePackage, AnnotationDB db, ClasspathResolver resolver) throws IOException {
        String resource = basePackage.replace('.', '/');
        Enumeration<URL> urls = resolver.getClassLoader().getResources(resource);
        if (!urls.hasMoreElements()) {
            logger.error("There's no occurence of package {} in classpath", (Object)basePackage);
            return;
        }
        do {
            String fileName = null;
            URL url = urls.nextElement();
            logger.info("scanning url {}", (Object)url);
            fileName = url.getProtocol().equals("vfs") ? this.toJBossVFSFileName(url) : this.toFileName(resource, url.getFile());
            if (!fileName.startsWith("file:")) {
                fileName = "file:" + fileName;
            }
            db.scanArchives(new URL[]{new URL(fileName)});
        } while (urls.hasMoreElements());
    }

    private String toJBossVFSFileName(URL url) throws IOException {
        Object content = url.openConnection().getContent();
        File pfile = (File)new Mirror().on(content).invoke().method("getPhysicalFile").withoutArgs();
        logger.info("real file for url {} is {}", (Object)url, (Object)pfile);
        if (pfile.isDirectory()) {
            return pfile.getAbsolutePath() + "/";
        }
        return pfile.getAbsolutePath();
    }

    private String toFileName(String resource, String file) {
        return file.substring(0, file.length() - resource.length() - 1).replaceAll("(!)(/)?$", "");
    }

    private Set<String> findStereotypes(Map<String, Set<String>> webInfClassesAnnotationMap, Map<String, Set<String>> basePackagesAnnotationMap, List<String> basePackages) {
        HashSet<String> results = new HashSet<String>();
        this.addVRaptorStereotypes(results);
        this.addWebInfClassesStereotypes(webInfClassesAnnotationMap, results);
        this.addBasePackagesStereotypes(basePackagesAnnotationMap, basePackages, results);
        return results;
    }

    private void addBasePackagesStereotypes(Map<String, Set<String>> basePackagesAnnotationMap, List<String> basePackages, HashSet<String> results) {
        Set<String> libStereotypes = this.nullToEmpty(basePackagesAnnotationMap.get(Stereotype.class.getName()));
        for (String stereotype : libStereotypes) {
            if (!this.packagesContains(basePackages, stereotype)) continue;
            results.add(stereotype);
        }
    }

    private boolean packagesContains(List<String> basePackages, String clazz) {
        for (String basePackage : basePackages) {
            if (!clazz.startsWith(basePackage)) continue;
            return true;
        }
        return false;
    }

    private void addWebInfClassesStereotypes(Map<String, Set<String>> webInfClassesAnnotationMap, HashSet<String> results) {
        Set<String> myStereotypes = this.nullToEmpty(webInfClassesAnnotationMap.get(Stereotype.class.getName()));
        results.addAll(myStereotypes);
    }

    private void addVRaptorStereotypes(HashSet<String> results) {
        for (Class<? extends Annotation> stereotype : BaseComponents.getStereotypes()) {
            results.add(stereotype.getName());
        }
    }

    private void findComponentsFromWebInfClasses(Map<String, Set<String>> index, Set<String> stereotypeNames, Set<String> results) {
        for (String stereotype : stereotypeNames) {
            Set<String> classes = this.nullToEmpty(index.get(stereotype));
            results.addAll(classes);
        }
    }

    private void findComponentsFromBasePackages(Map<String, Set<String>> index, List<String> basePackages, Set<String> results) {
        for (Class<? extends Annotation> stereotype : BaseComponents.getStereotypes()) {
            Set<String> classes = this.nullToEmpty(index.get(stereotype.getName()));
            for (String clazz : classes) {
                if (!this.packagesContains(basePackages, clazz)) continue;
                results.add(clazz);
            }
        }
    }

    private <T> Set<T> nullToEmpty(Set<T> set) {
        return (Set)Objects.firstNonNull(set, Collections.emptySet());
    }

    private AnnotationDB createAnnotationDB() {
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(true);
        db.setScanFieldAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.setScanParameterAnnotations(false);
        return db;
    }
}

