/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.scan;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.scan.ScannerException;
import br.com.caelum.vraptor.scan.WebAppBootstrap;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicWebAppBootstrap
implements WebAppBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(DynamicWebAppBootstrap.class);
    private final Collection<String> classNames;

    public DynamicWebAppBootstrap(Collection<String> classNames) {
        this.classNames = classNames;
    }

    @Override
    public void configure(ComponentRegistry registry) {
        for (String className : this.classNames) {
            logger.trace("Registering class {}", (Object)className);
            try {
                Class<?> clazz = Class.forName(className);
                registry.deepRegister(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new ScannerException("Error while registering classes", e);
            }
        }
    }
}

