/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.restfulie.relation;

import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.restfulie.relation.Relation;
import br.com.caelum.vraptor.restfulie.relation.RelationBuilder;
import br.com.caelum.vraptor.restfulie.relation.UriBasedRelation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRelationBuilder
implements RelationBuilder {
    private final List<Relation> relations = new ArrayList<Relation>();
    private final Proxifier proxifier;
    private final Router router;

    public DefaultRelationBuilder(Router router, Proxifier proxifier) {
        this.router = router;
        this.proxifier = proxifier;
    }

    @Override
    public void add(Relation relation) {
        this.relations.add(relation);
    }

    @Override
    public RelationBuilder.WithName relation(String name) {
        return new WithNameImpl(name);
    }

    @Override
    public List<Relation> getRelations() {
        return new ArrayList<Relation>(this.relations);
    }

    @Override
    public <T> T relation(final Class<T> type) {
        return this.proxifier.proxify(type, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                Object instance = DefaultRelationBuilder.this.relation(method.getName()).uses(type);
                new Mirror().on(instance).invoke().method(method).withArgs(args);
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WithNameImpl
    implements RelationBuilder.WithName {
        private final String name;

        public WithNameImpl(String name) {
            this.name = name;
        }

        @Override
        public void at(String uri) {
            DefaultRelationBuilder.this.relations.add(new UriBasedRelation(this.name, uri));
        }

        @Override
        public <T> T uses(final Class<T> controller) {
            return DefaultRelationBuilder.this.proxifier.proxify(controller, new MethodInvocation<T>(){

                @Override
                public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                    DefaultRelationBuilder.this.relations.add(new UriBasedRelation(WithNameImpl.this.name, DefaultRelationBuilder.this.router.urlFor(controller, method, args)));
                    return null;
                }
            });
        }
    }
}

