/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.spring.ComponentFactoryBean;
import br.com.caelum.vraptor.ioc.spring.DefaultSpringLocator;
import br.com.caelum.vraptor.ioc.spring.HttpServletRequestProvider;
import br.com.caelum.vraptor.ioc.spring.HttpServletResponseProvider;
import br.com.caelum.vraptor.ioc.spring.HttpSessionProvider;
import br.com.caelum.vraptor.ioc.spring.InjectionBeanPostProcessor;
import br.com.caelum.vraptor.ioc.spring.SpringBasedContainer;
import br.com.caelum.vraptor.ioc.spring.StereotypedBeansRegistrar;
import br.com.caelum.vraptor.ioc.spring.UniqueBeanNameGenerator;
import br.com.caelum.vraptor.ioc.spring.VRaptorRequestProvider;
import br.com.caelum.vraptor.ioc.spring.VRaptorScopeResolver;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.aop.config.AopConfigUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringRegistry {
    private final BeanNameGenerator beanNameGenerator = new UniqueBeanNameGenerator((BeanNameGenerator)new AnnotationBeanNameGenerator());
    private final ConfigurableListableBeanFactory beanFactory;
    private final VRaptorScopeResolver scopeResolver = new VRaptorScopeResolver();
    private final Container container;

    public SpringRegistry(ConfigurableListableBeanFactory configurableListableBeanFactory, Container container) {
        this.beanFactory = configurableListableBeanFactory;
        this.container = container;
    }

    private void registerOn(Class<?> type, boolean customComponent) {
        AnnotatedGenericBeanDefinition definition = new AnnotatedGenericBeanDefinition(type);
        if (!customComponent) {
            definition.setLazyInit(true);
        }
        definition.setAutowireMode(0);
        definition.setPrimary(customComponent);
        definition.setRole(customComponent ? 0 : 2);
        String name = this.beanNameGenerator.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)this.beanFactory);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)definition, name);
        ScopeMetadata scopeMetadata = this.scopeResolver.resolveScopeMetadata((BeanDefinition)definition);
        definitionHolder = this.applyScopeOn(definitionHolder, scopeMetadata);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)((BeanDefinitionRegistry)this.beanFactory));
    }

    private BeanDefinitionHolder applyScopeOn(BeanDefinitionHolder definition, ScopeMetadata scopeMetadata) {
        String scope = scopeMetadata.getScopeName();
        ScopedProxyMode proxyMode = scopeMetadata.getScopedProxyMode();
        definition.getBeanDefinition().setScope(scope);
        if ("singleton".equals(scope) || "prototype".equals(scope) || proxyMode.equals((Object)ScopedProxyMode.NO)) {
            return definition;
        }
        boolean proxyTargetClass = proxyMode.equals((Object)ScopedProxyMode.TARGET_CLASS);
        return ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definition, (BeanDefinitionRegistry)((BeanDefinitionRegistry)this.beanFactory), (boolean)proxyTargetClass);
    }

    private void registerOn(Class<?> type) {
        this.registerOn(type, false);
    }

    private void registerFactory(Class<?> type) {
        if (ComponentFactory.class.isAssignableFrom(type)) {
            this.beanFactory.registerSingleton(type.getName(), new ComponentFactoryBean(this.container, type));
        }
    }

    void register(Class<?> type) {
        this.register(type, true);
    }

    private void register(Class<?> type, boolean customComponent) {
        this.registerOn(type, customComponent);
        this.registerFactory(type);
    }

    private void registerPrototypeScopedComponentsOn() {
        for (Class<?> prototypeComponent : BaseComponents.getPrototypeScoped().values()) {
            this.registerOn(prototypeComponent);
        }
    }

    private void registerCachedComponentsOn() {
        for (Class<?> cachedComponent : BaseComponents.getCachedComponents().values()) {
            this.registerOn(cachedComponent, true);
        }
    }

    private void registerApplicationScopedComponentsOn() {
        this.registerComponents(BaseComponents.getApplicationScoped().values());
        this.registerComponents(Arrays.asList(BaseComponents.getStereotypeHandlers()));
        this.registerOn(StereotypedBeansRegistrar.class);
        this.registerOn(DefaultSpringLocator.class);
    }

    private void registerRequestScopedComponentsOn() {
        this.registerComponents(BaseComponents.getRequestScoped().values());
        this.registerComponents(BaseComponents.getBundledConverters());
        this.registerOn(VRaptorRequestProvider.class, true);
        this.registerOn(HttpServletRequestProvider.class, true);
        this.registerOn(HttpServletResponseProvider.class, true);
        this.registerOn(HttpSessionProvider.class, true);
        this.beanFactory.registerSingleton(SpringBasedContainer.class.getName(), (Object)this.container);
    }

    private void registerVRaptorComponents() {
        this.registerApplicationScopedComponentsOn();
        this.registerRequestScopedComponentsOn();
        this.registerPrototypeScopedComponentsOn();
    }

    private void registerCustomInjectionProcessor() {
        RootBeanDefinition definition = new RootBeanDefinition(InjectionBeanPostProcessor.class);
        definition.setRole(2);
        definition.getPropertyValues().addPropertyValue("order", (Object)Integer.MAX_VALUE);
        ((BeanDefinitionRegistry)this.beanFactory).registerBeanDefinition("org.springframework.context.annotation.internalAutowiredAnnotationProcessor", (BeanDefinition)definition);
    }

    void registerCustomComponents(Collection<Class<?>> toRegister) {
        for (Class<?> type : toRegister) {
            this.register(type);
        }
    }

    private <T> void registerComponents(Collection<Class<? extends T>> toRegister) {
        for (Class<T> clazz : toRegister) {
            this.register(clazz, false);
        }
    }

    void configure() {
        this.registerVRaptorComponents();
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)((BeanDefinitionRegistry)this.beanFactory));
        AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)((BeanDefinitionRegistry)this.beanFactory));
        this.registerCustomInjectionProcessor();
        this.registerCachedComponentsOn();
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)this.beanFactory);
    }
}

