/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.spring.SpringLocator;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

@ApplicationScoped
public class DefaultSpringLocator
implements SpringLocator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringLocator.class);

    public ConfigurableWebApplicationContext getApplicationContext(ServletContext servletContext) {
        ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (context != null) {
            logger.info("Using a web application context: " + context);
            return context;
        }
        if (DefaultSpringLocator.class.getResource("/applicationContext.xml") != null) {
            logger.info("Using an XmlWebApplicationContext, searching for applicationContext.xml");
            XmlWebApplicationContext ctx = new XmlWebApplicationContext();
            ctx.setConfigLocation("classpath:applicationContext.xml");
            return ctx;
        }
        logger.info("No application context found");
        AnnotationConfigWebApplicationContext ctx = new AnnotationConfigWebApplicationContext();
        ctx.setId("VRaptor");
        return ctx;
    }
}

