/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.spring.ComponentFactoryBean;
import br.com.caelum.vraptor.ioc.spring.ComponentTypeFilter;
import br.com.caelum.vraptor.ioc.spring.UniqueBeanNameGenerator;
import br.com.caelum.vraptor.ioc.spring.VRaptorScopeResolver;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;

class ComponentScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger logger = LoggerFactory.getLogger(ComponentScanner.class);
    private final ConfigurableListableBeanFactory registry;
    private final Container container;

    public ComponentScanner(ConfigurableListableBeanFactory registry, Container container) {
        super((BeanDefinitionRegistry)registry, false);
        this.registry = registry;
        this.container = container;
        this.addIncludeFilter(new ComponentTypeFilter());
        this.setScopeMetadataResolver(new VRaptorScopeResolver());
        this.setBeanNameGenerator(new UniqueBeanNameGenerator((BeanNameGenerator)new AnnotationBeanNameGenerator()));
    }

    protected void postProcessBeanDefinition(AbstractBeanDefinition beanDefinition, String beanName) {
        super.postProcessBeanDefinition(beanDefinition, beanName);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(3);
        try {
            Class<?> componentType = Class.forName(beanDefinition.getBeanClassName());
            if (ComponentFactory.class.isAssignableFrom(componentType) && this.checkCandidate(beanName, (BeanDefinition)beanDefinition)) {
                this.registry.registerSingleton(beanDefinition.getBeanClassName(), new ComponentFactoryBean(this.container, componentType));
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn("Class " + beanDefinition.getBeanClassName() + " was not found during bean definition proccess");
        }
        catch (ExceptionInInitializerError e) {
            logger.warn("Class " + beanDefinition.getBeanClassName() + " has problems during initialization", e.getCause());
            throw e;
        }
    }

    public int scan(String ... basePackages) {
        logger.debug("scanning " + Arrays.toString(basePackages));
        return super.scan(basePackages);
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) throws IllegalStateException {
        if (this.registry.containsBeanDefinition(beanName) && this.registry.getBeanDefinition(beanName).getBeanClassName().equals(beanDefinition.getBeanClassName())) {
            logger.warn("bean already found previously, there is probably no need to declare its package in web.xml:" + beanDefinition.getBeanClassName());
            return false;
        }
        return super.checkCandidate(beanName, beanDefinition);
    }
}

