/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.ioc.guice.AbstractScope;
import br.com.caelum.vraptor.ioc.guice.LifecycleListener;
import br.com.caelum.vraptor.ioc.guice.LifecycleScope;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCustomScope
extends AbstractScope
implements LifecycleScope {
    private static final Logger logger = LoggerFactory.getLogger(RequestCustomScope.class);
    private final ThreadLocal<List<LifecycleListener>> listeners = new ThreadLocal();
    private Provider<HttpServletRequest> provider;

    @Inject
    public void setProvider(Provider<HttpServletRequest> provider) {
        this.provider = provider;
    }

    @Override
    AbstractScope.ScopeHolder getHolder() {
        return new AbstractScope.ScopeHolder(){

            public void setAttribute(String name, Object value) {
                ((HttpServletRequest)RequestCustomScope.this.provider.get()).setAttribute(name, value);
            }

            public Object getAttribute(String name) {
                return ((HttpServletRequest)RequestCustomScope.this.provider.get()).getAttribute(name);
            }
        };
    }

    @Override
    String getScopeName() {
        return "REQUEST";
    }

    public void start() {
        this.listeners.set(new ArrayList());
    }

    public void stop() {
        for (LifecycleListener listener : this.listeners.get()) {
            try {
                listener.onEvent();
            }
            catch (Exception e) {
                logger.warn("Error while invoking PreDestroy", (Throwable)e);
            }
        }
    }

    @Override
    public void registerDestroyListener(LifecycleListener listener) {
        this.listeners.get().add(listener);
    }
}

