/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScope
implements Scope {
    private TypeNameExtractor extractor;

    @Inject
    public void setExtractor(TypeNameExtractor extractor) {
        this.extractor = extractor;
    }

    abstract ScopeHolder getHolder();

    abstract String getScopeName();

    public <T> Provider<T> scope(Key<T> key, Provider<T> creator) {
        return new ScopedProvider(key, creator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScopedProvider<T>
    implements Provider<T> {
        private final Key<T> key;
        private final Provider<T> creator;
        private String name;

        private ScopedProvider(Key<T> key, Provider<T> creator) {
            this.key = key;
            this.creator = creator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            ScopeHolder holder;
            ScopeHolder scopeHolder = holder = AbstractScope.this.getHolder();
            synchronized (scopeHolder) {
                Object obj = holder.getAttribute(this.getName());
                if (NullObject.INSTANCE == obj) {
                    return null;
                }
                Object t = obj;
                if (t == null) {
                    t = this.creator.get();
                    holder.setAttribute(this.getName(), t != null ? t : NullObject.INSTANCE);
                }
                return (T)t;
            }
        }

        public String toString() {
            return String.format("%s[%s]", this.creator, AbstractScope.this.getScopeName());
        }

        private String getName() {
            if (this.name == null) {
                this.name = AbstractScope.this.extractor.nameFor(this.key.getTypeLiteral().getType());
            }
            return this.name;
        }
    }

    static interface ScopeHolder {
        public Object getAttribute(String var1);

        public void setAttribute(String var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullObject {
        INSTANCE;

    }
}

