/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc;

import br.com.caelum.vraptor.Resource;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.http.route.RoutesParser;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.resource.DefaultResourceClass;
import br.com.caelum.vraptor.view.LinkToHandler;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
@Component(value="stereotypeHandler")
public class ResourceHandler
implements StereotypeHandler {
    private final Logger logger = LoggerFactory.getLogger(ResourceHandler.class);
    private final Router router;
    private final RoutesParser parser;
    private final ServletContext context;

    public ResourceHandler(Router router, RoutesParser parser, ServletContext context) {
        this.router = router;
        this.parser = parser;
        this.context = context;
    }

    @PostConstruct
    public void configureLinkToHandler() {
        new LinkToHandler(this.context, this.router).start();
    }

    @Override
    public void handle(Class<?> annotatedType) {
        this.logger.debug("Found resource: " + annotatedType);
        List<Route> routes = this.parser.rulesFor(new DefaultResourceClass(annotatedType));
        for (Route route : routes) {
            this.router.add(route);
        }
        this.context.setAttribute(annotatedType.getSimpleName(), annotatedType);
    }

    @Override
    public Class<? extends Annotation> stereotype() {
        return Resource.class;
    }
}

