/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class ConverterHandler
implements StereotypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConverterHandler.class);
    private Converters converters;

    public ConverterHandler(Converters converters) {
        this.converters = converters;
    }

    @Override
    public void handle(Class<?> annotatedType) {
        if (!Converter.class.isAssignableFrom(annotatedType)) {
            throw new VRaptorException("converter does not implement Converter");
        }
        if (BaseComponents.getBundledConverters().contains(annotatedType)) {
            logger.debug("Ignoring handling default converter {}", annotatedType);
            return;
        }
        Class<?> converterType = annotatedType;
        this.converters.register(converterType);
    }

    @Override
    public Class<? extends Annotation> stereotype() {
        return Convert.class;
    }
}

