/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc;

import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.ComponentRegistrationException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFactoryIntrospector {
    public Class<?> targetTypeForComponentFactory(Class<?> type) {
        Class<?> c = this.targetTypeForComponentFactory0(type);
        if (c == null) {
            throw new ComponentRegistrationException("Class does not implements ComponentFactory " + type);
        }
        return c;
    }

    private Class<?> targetTypeForComponentFactory0(Class<?> type) {
        Class<?> c;
        Type[] interfaces;
        for (Type type2 : interfaces = type.getGenericInterfaces()) {
            if (type2 instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type2).getRawType();
                Type[] typeArguments = ((ParameterizedType)type2).getActualTypeArguments();
                if (!ComponentFactory.class.equals((Object)rawType)) continue;
                return (Class)typeArguments[0];
            }
            if (!ComponentFactory.class.equals((Object)type2)) continue;
            throw new ComponentRegistrationException("The class implementing ComponentFactory<T> must define the generic argument. Eg.: public class MyFactory implements ComponentFactory<MyComponent> { ... }");
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && (c = this.targetTypeForComponentFactory0(superClass)) != null) {
            return c;
        }
        for (Type type3 : type.getInterfaces()) {
            Class<?> c2 = this.targetTypeForComponentFactory0((Class<?>)type3);
            if (c2 == null) continue;
            return c2;
        }
        return null;
    }
}

