/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.multipart;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.interceptor.multipart.UploadedFile;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=UploadedFile.class)
public class UploadedFileConverter
implements Converter<UploadedFile> {
    private static final Logger logger = LoggerFactory.getLogger(UploadedFileConverter.class);
    private final HttpServletRequest request;

    public UploadedFileConverter(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public UploadedFile convert(String value, Class<? extends UploadedFile> type, ResourceBundle bundle) {
        Object upload = this.request.getAttribute(value);
        if (upload == null) {
            logger.warn("There was an error when uploading the file {}. Please verify if commons-fileupload jars are in your classpath or you are using a Servlet 3 Container.");
            throw new ConversionError("Invalid upload");
        }
        return type.cast(upload);
    }
}

