/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Lazy;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.interceptor.ExecuteMethodInterceptor;
import br.com.caelum.vraptor.interceptor.ForwardToDefaultViewInterceptor;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(after={ExecuteMethodInterceptor.class}, before={ForwardToDefaultViewInterceptor.class})
@Lazy
public class OutjectResult
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(OutjectResult.class);
    private final Result result;
    private final MethodInfo info;
    private final TypeNameExtractor extractor;

    public OutjectResult(Result result, MethodInfo info, TypeNameExtractor extractor) {
        this.result = result;
        this.info = info;
        this.extractor = extractor;
    }

    public boolean accepts(ResourceMethod method) {
        Type returnType = method.getMethod().getGenericReturnType();
        return !returnType.equals(Void.TYPE);
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Type returnType = method.getMethod().getGenericReturnType();
        String name = this.extractor.nameFor(returnType);
        Object value = this.info.getResult();
        logger.debug("outjecting {}={}", (Object)name, value);
        this.result.include(name, value);
        stack.next(method, resourceInstance);
    }
}

