/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.util.StringUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultTypeNameExtractor
implements TypeNameExtractor {
    @Override
    public String nameFor(Type generic) {
        if (generic instanceof ParameterizedType) {
            return this.nameFor((ParameterizedType)generic);
        }
        if (generic instanceof WildcardType) {
            return this.nameFor((WildcardType)generic);
        }
        if (generic instanceof TypeVariable) {
            return this.nameFor((TypeVariable)generic);
        }
        return this.nameFor((Class)generic);
    }

    private String nameFor(Class<?> raw) {
        if (raw.isArray()) {
            return this.nameFor(raw.getComponentType()) + "List";
        }
        String name = raw.getSimpleName();
        return StringUtils.lowercaseFirst(name);
    }

    private String nameFor(TypeVariable<?> variable) {
        return StringUtils.lowercaseFirst(variable.getName());
    }

    private String nameFor(WildcardType wild) {
        if (wild.getLowerBounds().length != 0) {
            return this.nameFor(wild.getLowerBounds()[0]);
        }
        return this.nameFor(wild.getUpperBounds()[0]);
    }

    private String nameFor(ParameterizedType type) {
        Class raw = (Class)type.getRawType();
        if (Collection.class.isAssignableFrom(raw)) {
            return this.nameFor(type.getActualTypeArguments()[0]) + "List";
        }
        return this.nameFor(raw);
    }
}

