/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.route.Route;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityRoutesList
implements Collection<Route> {
    private final SortedMap<Integer, Set<Route>> map;
    private List<Route> cache;
    private Lock cacheLock = new ReentrantLock();

    public PriorityRoutesList() {
        this.map = new TreeMap<Integer, Set<Route>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Route> getFullList() {
        try {
            this.cacheLock.lock();
            if (this.cache == null) {
                this.cache = new LinkedList<Route>();
                for (Map.Entry<Integer, Set<Route>> entry : this.map.entrySet()) {
                    this.cache.addAll((Collection<Route>)entry.getValue());
                }
            }
            List<Route> list = this.cache;
            return list;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private Set<Route> getSetFor(Route e) {
        if (!this.map.containsKey(e.getPriority())) {
            this.map.put(e.getPriority(), new LinkedHashSet());
        }
        return (Set)this.map.get(e.getPriority());
    }

    @Override
    public boolean add(Route e) {
        this.cache = null;
        return this.getSetFor(e).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends Route> c) {
        for (Route route : c) {
            this.add(route);
        }
        return true;
    }

    @Override
    public void clear() {
        this.cache = null;
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getFullList().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getFullList().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getFullList().isEmpty();
    }

    @Override
    public Iterator<Route> iterator() {
        return this.getFullList().iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getFullList().size();
    }

    @Override
    public Object[] toArray() {
        return this.getFullList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getFullList().toArray(a);
    }
}

