/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.http.route.Evaluator;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;

@ApplicationScoped
public class JavaEvaluator
implements Evaluator {
    public Object get(Object root, String path) {
        if (root == null) {
            return null;
        }
        String[] paths = path.split("[\\]\\.]");
        Object current = root;
        for (int i = 1; i < paths.length; ++i) {
            try {
                current = this.navigate(current, paths[i]);
            }
            catch (Exception e) {
                throw new VRaptorException("Unable to evaluate expression " + path, e);
            }
            if (current != null) continue;
            return "";
        }
        return current;
    }

    private Object navigate(Object current, String path) {
        int index = path.indexOf("[");
        int position = -1;
        if (index != -1) {
            position = Integer.parseInt(path.substring(index + 1));
            path = path.substring(0, index);
        }
        Object instance = new Mirror().on(current).invoke().getterFor(path);
        if (index != -1) {
            instance = this.access(instance, position);
        }
        return instance;
    }

    private Object access(Object current, int position) {
        if (current.getClass().isArray()) {
            return Array.get(current, position);
        }
        if (List.class.isAssignableFrom(current.getClass())) {
            return ((List)current).get(position);
        }
        if (Collection.class.isAssignableFrom(current.getClass())) {
            Iterator it = ((Collection)current).iterator();
            for (int i = 0; i < position; ++i) {
                it.next();
            }
            return it.next();
        }
        throw new VRaptorException("Unable to access position of a" + current.getClass().getName() + ".");
    }
}

