/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.Stringnifier;
import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedMethodStrategy
implements Route {
    private final ResourceMethod resourceMethod;
    private final EnumSet<HttpMethod> methods;
    private final ParametersControl parameters;
    private final int priority;
    private final String originalUri;
    private final String[] parameterNames;

    public FixedMethodStrategy(String originalUri, ResourceMethod method, Set<HttpMethod> methods, ParametersControl control, int priority, String[] parameterNames) {
        this.originalUri = originalUri;
        this.parameterNames = parameterNames;
        this.methods = methods.isEmpty() ? EnumSet.allOf(HttpMethod.class) : EnumSet.copyOf(methods);
        this.parameters = control;
        this.resourceMethod = method;
        this.priority = priority;
    }

    @Override
    public boolean canHandle(Class<?> type, Method method) {
        return type.equals(this.resourceMethod.getResource().getType()) && method.equals(this.resourceMethod.getMethod());
    }

    @Override
    public ResourceMethod resourceMethod(MutableRequest request, String uri) {
        this.parameters.fillIntoRequest(uri, request);
        return this.resourceMethod;
    }

    @Override
    public EnumSet<HttpMethod> allowedMethods() {
        return this.methods;
    }

    @Override
    public boolean canHandle(String uri) {
        return this.parameters.matches(uri);
    }

    @Override
    public String urlFor(Class<?> type, Method m, Object ... params) {
        return this.parameters.fillUri(this.parameterNames, params);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getOriginalUri() {
        return this.originalUri;
    }

    public String toString() {
        return String.format("[FixedMethodStrategy: %-65s %-70s %s]", this.originalUri, Stringnifier.simpleNameFor(this.resourceMethod.getMethod()), this.methods.size() == HttpMethod.values().length ? "ALL" : this.methods);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        result = 31 * result + (this.originalUri == null ? 0 : this.originalUri.hashCode());
        result = 31 * result + (this.resourceMethod == null ? 0 : this.resourceMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedMethodStrategy other = (FixedMethodStrategy)obj;
        return Objects.equal(this.methods, other.methods) && Objects.equal((Object)this.originalUri, (Object)other.originalUri) && Objects.equal((Object)this.resourceMethod, (Object)other.resourceMethod);
    }
}

