/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.route.DefaultRouteBuilder;
import br.com.caelum.vraptor.http.route.Evaluator;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.PriorityRoutesList;
import br.com.caelum.vraptor.http.route.ResourceNotFoundException;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.RouteNotFoundException;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.http.route.RoutesConfiguration;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.collections.Filters;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultRouter
implements Router {
    private final Proxifier proxifier;
    private final Collection<Route> routes = new PriorityRoutesList();
    private final TypeFinder finder;
    private final Converters converters;
    private final ParameterNameProvider nameProvider;
    private final Evaluator evaluator;

    public DefaultRouter(RoutesConfiguration config, Proxifier proxifier, TypeFinder finder, Converters converters, ParameterNameProvider nameProvider, Evaluator evaluator) {
        this.proxifier = proxifier;
        this.finder = finder;
        this.converters = converters;
        this.nameProvider = nameProvider;
        this.evaluator = evaluator;
        config.config(this);
    }

    @Override
    public RouteBuilder builderFor(String uri) {
        return new DefaultRouteBuilder(this.proxifier, this.finder, this.converters, this.nameProvider, this.evaluator, uri);
    }

    @Override
    public void add(Route r) {
        this.routes.add(r);
    }

    @Override
    public ResourceMethod parse(String uri, HttpMethod method, MutableRequest request) throws MethodNotAllowedException {
        Collection<Route> routesMatchingUriAndMethod = this.routesMatchingUriAndMethod(uri, method);
        Iterator<Route> iterator = routesMatchingUriAndMethod.iterator();
        Route route = iterator.next();
        this.checkIfThereIsAnotherRoute(uri, method, iterator, route);
        return route.resourceMethod(request, uri);
    }

    private void checkIfThereIsAnotherRoute(String uri, HttpMethod method, Iterator<Route> iterator, Route route) {
        if (iterator.hasNext()) {
            Route otherRoute = iterator.next();
            if (route.getPriority() == otherRoute.getPriority()) {
                throw new IllegalStateException(MessageFormat.format("There are two rules that matches the uri ''{0}'' with method {1}: {2} with same priority. Consider using @Path priority attribute.", new Object[]{uri, method, Arrays.asList(route, otherRoute)}));
            }
        }
    }

    private Collection<Route> routesMatchingUriAndMethod(String uri, HttpMethod method) {
        Collection routesMatchingMethod = Collections2.filter(this.routesMatchingUri(uri), Filters.allow(method));
        if (routesMatchingMethod.isEmpty()) {
            EnumSet<HttpMethod> allowed = this.allowedMethodsFor(uri);
            throw new MethodNotAllowedException(allowed, method.toString());
        }
        return routesMatchingMethod;
    }

    @Override
    public EnumSet<HttpMethod> allowedMethodsFor(String uri) {
        EnumSet<HttpMethod> allowed = EnumSet.noneOf(HttpMethod.class);
        for (Route route : this.routesMatchingUri(uri)) {
            allowed.addAll(route.allowedMethods());
        }
        return allowed;
    }

    private Collection<Route> routesMatchingUri(String uri) {
        Collection routesMatchingURI = Collections2.filter(this.routes, Filters.canHandle(uri));
        if (routesMatchingURI.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        return routesMatchingURI;
    }

    @Override
    public <T> String urlFor(Class<T> type, Method method, Object ... params) {
        UnmodifiableIterator matches = Iterators.filter(this.routes.iterator(), Filters.canHandle(type, method));
        if (matches.hasNext()) {
            try {
                return ((Route)matches.next()).urlFor(type, method, params);
            }
            catch (Exception e) {
                throw new VRaptorException("The selected route is invalid for redirection: " + type.getName() + "." + method.getName(), e);
            }
        }
        throw new RouteNotFoundException("The selected route is invalid for redirection: " + type.getName() + "." + method.getName());
    }

    @Override
    public List<Route> allRoutes() {
        return Collections.unmodifiableList(new ArrayList<Route>(this.routes));
    }
}

