/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.ognl.ArrayAccessor;
import br.com.caelum.vraptor.http.ognl.EmptyElementsRemoval;
import br.com.caelum.vraptor.http.ognl.GenericNullHandler;
import br.com.caelum.vraptor.http.ognl.ListAccessor;
import br.com.caelum.vraptor.http.ognl.NullHandler;
import br.com.caelum.vraptor.http.ognl.ReflectionBasedNullHandler;
import br.com.caelum.vraptor.http.ognl.VRaptorConvertersAdapter;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.validator.annotation.ValidationException;
import com.google.common.collect.Maps;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class OgnlFacade {
    private static final Logger logger = LoggerFactory.getLogger(OgnlFacade.class);
    private final Proxifier proxifier;
    private final Converters converters;
    private final EmptyElementsRemoval removal;
    private final Map<Object, OgnlContext> contexts = Maps.newHashMap();

    public OgnlFacade(Converters converters, EmptyElementsRemoval removal, Proxifier proxifier) {
        this.converters = converters;
        this.removal = removal;
        this.proxifier = proxifier;
        OgnlRuntime.setNullHandler(Object.class, (ognl.NullHandler)new ReflectionBasedNullHandler(proxifier));
        OgnlRuntime.setPropertyAccessor(List.class, (PropertyAccessor)new ListAccessor(converters));
        OgnlRuntime.setPropertyAccessor(Object[].class, (PropertyAccessor)new ArrayAccessor());
    }

    public void startContext(String name, Type type, Object root, ResourceBundle bundle) {
        OgnlContext context = this.createOgnlContext(root);
        context.setTraceEvaluations(true);
        context.put((Object)"rootType", (Object)type);
        context.put((Object)"removal", (Object)this.removal);
        context.put((Object)"nullHandler", (Object)this.nullHandler());
        context.put(ResourceBundle.class, (Object)bundle);
        context.put((Object)"proxifier", (Object)this.proxifier);
        Ognl.setTypeConverter((Map)context, (TypeConverter)this.createAdapter(bundle));
        this.contexts.put(name, context);
    }

    protected VRaptorConvertersAdapter createAdapter(ResourceBundle bundle) {
        return new VRaptorConvertersAdapter(this.converters, bundle);
    }

    protected OgnlContext createOgnlContext(Object root) {
        return (OgnlContext)Ognl.createDefaultContext((Object)root);
    }

    protected NullHandler nullHandler() {
        return new GenericNullHandler(this.removal);
    }

    public void setValue(String name, String key, String[] values) {
        try {
            OgnlContext ctx = this.contexts.get(name);
            Ognl.setValue((String)key, (Map)ctx, (Object)ctx.getRoot(), (Object)(values.length == 1 ? values[0] : values));
            this.contexts.put(ctx.getRoot(), ctx);
        }
        catch (MethodFailedException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().isAnnotationPresent(ValidationException.class)) {
                throw new ConversionError(cause.getLocalizedMessage());
            }
            throw new InvalidParameterException("unable to parse expression '" + key + "'", e);
        }
        catch (NoSuchPropertyException ex) {
            logger.debug("cant find property for expression {} ignoring", (Object)key);
            logger.trace("Reason:", (Throwable)ex);
        }
        catch (OgnlException e) {
            logger.debug("unable to parse expression '{}'. Ignoring.", (Object)key);
            logger.trace("Reason:", (Throwable)e);
        }
    }

    public Object get(String name) {
        Object root = this.contexts.remove(name).getRoot();
        this.removal.removeExtraElements();
        if (root.getClass().isArray()) {
            return this.removal.removeNullsFromArray(root);
        }
        return root;
    }
}

