/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.deserialization;

import br.com.caelum.vraptor.deserialization.Deserializer;
import br.com.caelum.vraptor.deserialization.Deserializes;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.serialization.xstream.VRaptorClassMapper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.InputStream;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deserializes(value={"application/json", "json"})
public class JsonDeserializer
implements Deserializer {
    private final ParameterNameProvider provider;
    private final TypeNameExtractor extractor;
    private HierarchicalStreamDriver driver = new JettisonMappedXmlDriver();

    public JsonDeserializer(ParameterNameProvider provider, TypeNameExtractor extractor) {
        this.provider = provider;
        this.extractor = extractor;
    }

    @Override
    public Object[] deserialize(InputStream inputStream, ResourceMethod method) {
        Method javaMethod = method.getMethod();
        Class<?>[] types = javaMethod.getParameterTypes();
        if (types.length == 0) {
            throw new IllegalArgumentException("Methods that consumes representations must receive just one argument: the root element");
        }
        XStream xStream = this.getConfiguredXStream(javaMethod, types);
        Object[] params = new Object[types.length];
        this.chooseParam(types, params, xStream.fromXML(inputStream));
        return params;
    }

    public XStream getConfiguredXStream(Method javaMethod, Class<?>[] types) {
        XStream xStream = this.getXStream();
        this.aliasParams(javaMethod, types, xStream);
        return xStream;
    }

    private void chooseParam(Class<?>[] types, Object[] params, Object deserialized) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInstance(deserialized)) continue;
            params[i] = deserialized;
        }
    }

    private void aliasParams(Method method, Class<?>[] types, XStream deserializer) {
        String[] names = this.provider.parameterNamesFor(method);
        for (int i = 0; i < names.length; ++i) {
            deserializer.alias(names[i], types[i]);
        }
    }

    protected XStream getXStream() {
        return new XStream(this.getHierarchicalStreamDriver()){
            {
                this.setMode(1001);
            }

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new VRaptorClassMapper((Mapper)next, JsonDeserializer.this.extractor);
            }
        };
    }

    protected HierarchicalStreamDriver getHierarchicalStreamDriver() {
        return this.driver;
    }
}

