/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorHandlerFactory;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.ForwardToDefaultViewInterceptor;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PrototypeScoped
public class DefaultInterceptorStack
implements InterceptorStack {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInterceptorStack.class);
    private final LinkedList<InterceptorHandler> interceptors = new LinkedList();
    private final InterceptorHandlerFactory handlerFactory;

    public DefaultInterceptorStack(InterceptorHandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    @Override
    public void next(ResourceMethod method, Object resourceInstance) throws InterceptionException {
        if (this.interceptors.isEmpty()) {
            logger.debug("All registered interceptors have been called. End of VRaptor Request Execution.");
            return;
        }
        InterceptorHandler handler = this.interceptors.poll();
        handler.execute(this, method, resourceInstance);
    }

    @Override
    public void add(Class<? extends Interceptor> type) {
        this.interceptors.addLast(this.handlerFactory.handlerFor(type));
    }

    @Override
    public void addAsNext(Class<? extends Interceptor> type) {
        if (!type.getPackage().getName().startsWith("br.com.caelum.vraptor.interceptor") && !type.equals(ForwardToDefaultViewInterceptor.class)) {
            this.interceptors.addFirst(this.handlerFactory.handlerFor(type));
        }
    }

    public String toString() {
        return "DefaultInterceptorStack " + this.interceptors;
    }
}

