/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.ExceptionMapper;
import br.com.caelum.vraptor.core.ExceptionRecorder;
import br.com.caelum.vraptor.proxy.Proxifier;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionMapper
implements ExceptionMapper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    private final Map<Class<? extends Exception>, ExceptionRecorder<Result>> exceptions;
    private final Proxifier proxifier;

    public DefaultExceptionMapper(Proxifier proxifier) {
        this.proxifier = proxifier;
        this.exceptions = Maps.newLinkedHashMap();
    }

    @Override
    public Result record(Class<? extends Exception> exception) {
        if (exception == null) {
            throw new NullPointerException("Exception cannot be null.");
        }
        ExceptionRecorder instance = new ExceptionRecorder(this.proxifier);
        this.exceptions.put(exception, instance);
        return this.proxifier.proxify(Result.class, instance);
    }

    @Override
    public ExceptionRecorder<Result> findByException(Exception e) {
        logger.debug("find for exception {}", e.getClass());
        for (Map.Entry<Class<? extends Exception>, ExceptionRecorder<Result>> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().isInstance(e)) continue;
            logger.debug("found exception mapping: {} -> {}", entry.getKey(), entry.getValue());
            return entry.getValue();
        }
        return this.hasExceptionCause(e) ? this.findByException((Exception)e.getCause()) : null;
    }

    private boolean hasExceptionCause(Exception e) {
        return e.getCause() != null && e.getCause() instanceof Exception;
    }
}

