/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.jodatime;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.converter.jodatime.LocaleBasedJodaTimeConverter;
import br.com.caelum.vraptor.core.Localization;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=LocalDate.class)
public class LocalDateConverter
implements Converter<LocalDate> {
    private final Localization localization;

    public LocalDateConverter(Localization localization) {
        this.localization = localization;
    }

    @Override
    public LocalDate convert(String value, Class<? extends LocalDate> type, ResourceBundle bundle) {
        try {
            Date date = new LocaleBasedJodaTimeConverter(this.localization).convert(value, type);
            if (date == null) {
                return null;
            }
            return LocalDate.fromDateFields((Date)date);
        }
        catch (Exception e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_date"), value));
        }
    }
}

