/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=double.class)
@ApplicationScoped
public class PrimitiveDoubleConverter
implements Converter<Double> {
    @Override
    public Double convert(String value, Class<? extends Double> type, ResourceBundle bundle) {
        if (Strings.isNullOrEmpty((String)value)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_number"), value));
        }
    }
}

