/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=Enum.class)
@ApplicationScoped
public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    @Override
    public T convert(String value, Class<? extends T> type, ResourceBundle bundle) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if (Character.isDigit(value.charAt(0))) {
            return this.resolveByOrdinal(value, type, bundle);
        }
        return this.resolveByName(value, type, bundle);
    }

    private T resolveByName(String value, Class<T> enumType, ResourceBundle bundle) {
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_enum_value"), value));
        }
    }

    private T resolveByOrdinal(String value, Class<T> enumType, ResourceBundle bundle) {
        try {
            int ordinal = Integer.parseInt(value);
            if (ordinal >= ((Enum[])enumType.getEnumConstants()).length) {
                throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_enum_value"), value));
            }
            return (T)((Enum[])enumType.getEnumConstants())[ordinal];
        }
        catch (NumberFormatException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_enum_value"), value));
        }
    }
}

