/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.config;

import br.com.caelum.vraptor.ioc.ContainerProvider;
import br.com.caelum.vraptor.ioc.guice.GuiceProvider;
import br.com.caelum.vraptor.ioc.pico.PicoProvider;
import br.com.caelum.vraptor.ioc.spring.MissingConfigurationException;
import br.com.caelum.vraptor.ioc.spring.SpringProvider;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BasicConfiguration.class);
    public static final String CONTAINER_PROVIDER = "br.com.caelum.vraptor.provider";
    public static final String ENCODING = "br.com.caelum.vraptor.encoding";
    public static final String BASE_PACKAGES_PARAMETER_NAME = "br.com.caelum.vraptor.packages";
    public static final String SCANNING_PARAM = "br.com.caelum.vraptor.scanning";
    private final ServletContext servletContext;

    public BasicConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ContainerProvider getProvider() throws ServletException {
        Class<? extends ContainerProvider> providerType = this.getProviderType();
        logger.info("Using {} as Container Provider", providerType);
        try {
            return providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getCause());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Class<? extends ContainerProvider> getProviderType() {
        String provider = this.servletContext.getInitParameter(CONTAINER_PROVIDER);
        if (provider != null) {
            try {
                return Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("You must configure a class that exists on the br.com.caelum.vraptor.provider context param.", e);
            }
        }
        if (this.classExists("org.springframework.context.ApplicationContext")) {
            return SpringProvider.class;
        }
        if (this.classExists("com.google.inject.Guice")) {
            return GuiceProvider.class;
        }
        if (this.classExists("org.picocontainer.PicoContainer")) {
            return PicoProvider.class;
        }
        throw new IllegalArgumentException("You don't have any DI container jars on your classpath. You can find them on vraptor-3.x.x.zip, so you must put one of the lib/containers/<container> jars on your classpath, where <container> is your preferred container.");
    }

    private boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean hasBasePackages() {
        return this.servletContext.getInitParameter(BASE_PACKAGES_PARAMETER_NAME) != null;
    }

    public String[] getBasePackages() {
        String packages = this.servletContext.getInitParameter(BASE_PACKAGES_PARAMETER_NAME);
        if (packages == null) {
            throw new MissingConfigurationException("br.com.caelum.vraptor.packages context-param not found in web.xml. Set this parameter with your base package");
        }
        return packages.trim().split(",\\s*");
    }

    public String getEncoding() {
        return this.servletContext.getInitParameter(ENCODING);
    }

    public String getWebinfClassesDirectory() {
        return this.servletContext.getRealPath("/WEB-INF/classes/");
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isClasspathScanningEnabled() {
        String scanningParam = this.servletContext.getInitParameter(SCANNING_PARAM);
        logger.info("{} = {}", (Object)SCANNING_PARAM, (Object)this.servletContext.getInitParameter(SCANNING_PARAM));
        return scanningParam == null || !scanningParam.trim().equals("disabled");
    }
}

