/***
 * Copyright (c) 2009 Caelum - www.caelum.com.br/opensource
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;

/**
 * The interceptors stack.
 *
 * @author Guilherme Silveira
 */
public interface InterceptorStack {

	/**
	 * Invokes the next interceptor on the stack.
	 */
    void next(ResourceMethod method, Object resourceInstance) throws InterceptionException;

    /**
     * Adds this interceptor at the end of the stack.
     */
    void add(Class<? extends Interceptor> interceptor);

    /**
     * Adds this interceptor at the head of the stack.
     */
    @Deprecated
    void addAsNext(Class<? extends Interceptor> interceptor);

}
