/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.masterslave.AsyncConnections;
import com.lambdaworks.redis.masterslave.Connections;
import com.lambdaworks.redis.masterslave.MasterSlaveUtils;
import com.lambdaworks.redis.masterslave.NodeConnectionFactory;
import com.lambdaworks.redis.masterslave.ReflectiveNodeConnectionFactory;
import com.lambdaworks.redis.masterslave.Requests;
import com.lambdaworks.redis.masterslave.TimedAsyncCommand;
import com.lambdaworks.redis.masterslave.TopologyComparators;
import com.lambdaworks.redis.masterslave.TopologyProvider;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

class MasterSlaveTopologyRefresh {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterSlaveTopologyRefresh.class);
    private static final StringCodec CODEC = StringCodec.UTF8;
    private final NodeConnectionFactory nodeConnectionFactory;
    private final TopologyProvider topologyProvider;

    MasterSlaveTopologyRefresh(RedisClient client, TopologyProvider topologyProvider) {
        this(new ReflectiveNodeConnectionFactory(client), topologyProvider);
    }

    MasterSlaveTopologyRefresh(NodeConnectionFactory nodeConnectionFactory, TopologyProvider topologyProvider) {
        this.nodeConnectionFactory = nodeConnectionFactory;
        this.topologyProvider = topologyProvider;
    }

    public List<RedisNodeDescription> getNodes(RedisURI seed) {
        List<RedisNodeDescription> nodes = this.topologyProvider.getNodes();
        this.addPasswordIfNeeded(nodes, seed);
        AsyncConnections asyncConnections = this.getConnections(nodes);
        try (Connections connections = null;){
            connections = asyncConnections.get(seed.getTimeout(), seed.getUnit());
            Requests requestedPing = connections.requestPing();
            List<RedisNodeDescription> list = this.getNodeSpecificViews(requestedPing, nodes, seed);
            return list;
        }
    }

    private void addPasswordIfNeeded(List<RedisNodeDescription> nodes, RedisURI seed) {
        if (seed.getPassword() != null && seed.getPassword().length != 0) {
            for (RedisNodeDescription node : nodes) {
                node.getUri().setPassword(new String(seed.getPassword()));
            }
        }
    }

    private List<RedisNodeDescription> getNodeSpecificViews(Requests requestedPing, List<RedisNodeDescription> nodes, RedisURI seed) throws InterruptedException {
        ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
        long timeout = seed.getUnit().toNanos(seed.getTimeout());
        HashMap<RedisNodeDescription, Long> latencies = new HashMap<RedisNodeDescription, Long>();
        requestedPing.await(timeout, TimeUnit.NANOSECONDS);
        for (RedisNodeDescription node : nodes) {
            TimedAsyncCommand<String, String, String> future = requestedPing.getRequest(node.getUri());
            if (future == null || !future.isDone()) continue;
            RedisNodeDescription redisNodeDescription = MasterSlaveUtils.findNodeByUri(nodes, node.getUri());
            latencies.put(redisNodeDescription, future.duration());
            result.add(redisNodeDescription);
        }
        TopologyComparators.SortAction sortAction = TopologyComparators.SortAction.getSortAction();
        sortAction.sort(result, new TopologyComparators.LatencyComparator(latencies));
        return result;
    }

    private AsyncConnections getConnections(Iterable<RedisNodeDescription> nodes) {
        AsyncConnections connections = new AsyncConnections();
        for (RedisNodeDescription node : nodes) {
            RedisURI redisURI = node.getUri();
            String message = String.format("Unable to connect to %s", redisURI);
            try {
                CompletableFuture<StatefulRedisConnection<String, String>> connectionFuture = this.nodeConnectionFactory.connectToNodeAsync(CODEC, redisURI);
                CompletableFuture<StatefulRedisConnection<String, String>> sync = new CompletableFuture<StatefulRedisConnection<String, String>>();
                connectionFuture.whenComplete((connection, throwable) -> {
                    if (throwable != null) {
                        if (throwable instanceof RedisConnectionException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(throwable.getMessage(), throwable);
                            } else {
                                logger.warn(throwable.getMessage());
                            }
                        } else {
                            logger.warn(message, throwable);
                        }
                        sync.completeExceptionally(new RedisConnectionException(message, (Throwable)throwable));
                    } else {
                        connection.async().clientSetname("lettuce#MasterSlaveTopologyRefresh");
                        sync.complete((StatefulRedisConnection<String, String>)connection);
                    }
                });
                connections.addConnection(redisURI, sync);
            }
            catch (RuntimeException e) {
                logger.warn(String.format(message, redisURI), (Throwable)e);
            }
        }
        return connections;
    }
}

