/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.cluster.api.rx.ReactiveExecutions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Observable;
import rx.Subscriber;

class ReactiveExecutionsImpl<T>
implements ReactiveExecutions<T> {
    private Map<RedisClusterNode, CompletableFuture<Observable<? extends T>>> executions;

    public ReactiveExecutionsImpl(Map<RedisClusterNode, CompletableFuture<Observable<? extends T>>> executions) {
        this.executions = executions;
    }

    @Override
    public Observable<T> observable() {
        return Observable.create(new FromCompletableFuture<T>(this.executions.values())).flatMap(observable -> observable);
    }

    @Override
    public Collection<RedisClusterNode> nodes() {
        return this.executions.keySet();
    }

    static class FromCompletableFuture<T>
    implements Observable.OnSubscribe<Observable<? extends T>> {
        private static final AtomicIntegerFieldUpdater<FromCompletableFuture> LATCH_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FromCompletableFuture.class, "latch");
        private static final AtomicIntegerFieldUpdater<FromCompletableFuture> TERMINATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FromCompletableFuture.class, "terminated");
        private final Collection<CompletableFuture<Observable<? extends T>>> futures;
        private volatile int latch;
        private volatile int terminated;

        public FromCompletableFuture(Collection<CompletableFuture<Observable<? extends T>>> futures) {
            this.futures = futures;
            LATCH_UPDATER.set(this, futures.size());
        }

        public void call(Subscriber<? super Observable<? extends T>> subscriber) {
            subscriber.onStart();
            for (CompletableFuture<Observable<T>> future : this.futures) {
                future.whenComplete((observable, throwable) -> {
                    if (throwable != null) {
                        if (TERMINATED_UPDATER.compareAndSet(this, 0, 1)) {
                            subscriber.onError(throwable);
                        }
                        return;
                    }
                    if (TERMINATED_UPDATER.get(this) == 1) {
                        return;
                    }
                    subscriber.onNext(observable);
                    if (LATCH_UPDATER.decrementAndGet(this) == 0) {
                        subscriber.onCompleted();
                    }
                });
            }
            if (this.futures.isEmpty()) {
                subscriber.onCompleted();
            }
        }
    }
}

