/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisBusyException;
import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.RedisCommandTimeoutException;
import com.lambdaworks.redis.RedisLoadingException;
import com.lambdaworks.redis.RedisNoScriptException;
import java.util.concurrent.TimeUnit;

public abstract class ExceptionFactory {
    private ExceptionFactory() {
    }

    public static RedisCommandTimeoutException createTimeoutException(long timeout, TimeUnit unit) {
        return new RedisCommandTimeoutException(String.format("Command timed out after %d %s", new Object[]{timeout, unit}));
    }

    public static RedisCommandTimeoutException createTimeoutException(String message, long timeout, TimeUnit unit) {
        return new RedisCommandTimeoutException(String.format("%s. Command timed out after %d %s", new Object[]{message, timeout, unit}));
    }

    public static RedisCommandExecutionException createExecutionException(String message) {
        return ExceptionFactory.createExecutionException(message, null);
    }

    public static RedisCommandExecutionException createExecutionException(String message, Throwable cause) {
        if (message != null) {
            if (message.startsWith("BUSY")) {
                return cause != null ? new RedisBusyException(message, cause) : new RedisBusyException(message);
            }
            if (message.startsWith("NOSCRIPT")) {
                return cause != null ? new RedisNoScriptException(message, cause) : new RedisNoScriptException(message);
            }
            if (message.startsWith("LOADING")) {
                return cause != null ? new RedisLoadingException(message, cause) : new RedisLoadingException(message);
            }
            return cause != null ? new RedisCommandExecutionException(message, cause) : new RedisCommandExecutionException(message);
        }
        return new RedisCommandExecutionException(cause);
    }
}

